#include "scripts.h"
#include "playland.h"
#include "engine.h"
#include "string"
//#include <windows.h>

bool CanBuild = false;
GameObject *MainTermObj, *UpTermObj, *DownTermObj, *ControlObj;
Vector3 MainTerm, UpTerm, DownTerm;

bool IsAGTEmpty = true;
Vector3 AGTEnter, AGTExit;
GameObject *AGTEnterObj, *AGTExitObj;

/*#define KEY_DOWN(vk_code) ((GetAsyncKeyState(vk_code) & 0x8000) ? 1 : 0)
#define KEY_UP(vk_code) ((GetAsyncKeyState(vk_code) & 0x8000) ? 0 : 1)
bool Veh_HV = false;
bool Veh_APC = false;
bool Veh_MRLS = false;
bool Veh_MED = false;
bool Veh_MAM = false;

void CALLBACK KeyState(HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime) {
	KillTimer(HWND_DESKTOP,idEvent);

	if (KEY_DOWN(VK_CONTROL)) {
		if (KEY_DOWN(VK_NUMPAD1) && !Veh_HV)	Veh_HV = true;
		if (KEY_DOWN(VK_NUMPAD2) && !Veh_APC)	Veh_APC = true;
		if (KEY_DOWN(VK_NUMPAD3) && !Veh_MRLS)	Veh_MRLS = true;
		if (KEY_DOWN(VK_NUMPAD4) && !Veh_MED)	Veh_MED = true;
		if (KEY_DOWN(VK_NUMPAD5) && !Veh_MAM)	Veh_MAM = true;
	}
	if (KEY_UP(VK_CONTROL)) {
		if (KEY_UP(VK_NUMPAD1) && Veh_HV) {
			Veh_HV = false;
			Vehicle_Purchase = "CnC_GDI_Humm-vee";
			Commands->Display_Int(0,"Selected Humm-vee\n");
		}
		if (KEY_UP(VK_NUMPAD2) && Veh_APC) {
			Veh_APC = false;
			Vehicle_Purchase = "CnC_GDI_APC";
			Commands->Display_Int(0,"Selected APC\n");
		}
		if (KEY_UP(VK_NUMPAD3) && Veh_MRLS) {
			Veh_MRLS = false;
			Vehicle_Purchase = "CnC_GDI_MRLS";
			Commands->Display_Int(0,"Selected MRLS\n");
		}
		if (KEY_UP(VK_NUMPAD4) && Veh_MED) {
			Veh_MED = false;
			Vehicle_Purchase = "CnC_GDI_Medium_Tank";
			Commands->Display_Int(0,"Selected Medium Tank\n");
		}
		if (KEY_UP(VK_NUMPAD5) && Veh_MAM) {
			Veh_MAM = false;
			Vehicle_Purchase = "CnC_GDI_Mammoth_Tank";
			Commands->Display_Int(0,"Selected Mammoth Tank\n");
		}
	}

	SetTimer(HWND_DESKTOP,1,1,(TIMERPROC)KeyState);
}*/


void KAK_Vehicle_Init::Created(GameObject *obj) {
	MainTerm.X = 35.000f;
	MainTerm.Y = -2.255f;
	MainTerm.Z = -3.487f;
	UpTerm.X = 35.750f;
	UpTerm.Y = -2.255f;
	UpTerm.Z = -3.487f;
	DownTerm.X = 34.250f;
	DownTerm.Y = -2.255f;
	DownTerm.Z = -3.487f;
	ControlObj = obj;
	MainTermObj = Commands->Create_Object("VehTerminal_Base_Empty",MainTerm);
	UpTermObj = Commands->Create_Object("VehTerminal_Up",UpTerm);
	DownTermObj = Commands->Create_Object("VehTerminal_Down",DownTerm);
	Commands->Set_Facing(MainTermObj,90.0f);
	Commands->Set_Facing(UpTermObj,90.0f);
	Commands->Set_Facing(DownTermObj,90.0f);
	Commands->Attach_Script(MainTermObj,"KAK_Vehicle_Purchase","");
	Commands->Attach_Script(UpTermObj,"KAK_Vehicle_Scroll","1");
	Commands->Attach_Script(DownTermObj,"KAK_Vehicle_Scroll","0");
	CanBuild = true;
	Commands->Enable_HUD_Pokable_Indicator(MainTermObj,true);
}

void KAK_Vehicle_Init::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		CanBuild = true;
		Commands->Enable_HUD_Pokable_Indicator(MainTermObj,true);
	}
}

void KAK_Vehicle_Init::Custom(GameObject *obj, int message, int param, GameObject *sender) {
	if (message == 1050) {
		CanBuild = false;
		Commands->Start_Timer(obj,this,12.0f,1);
		Commands->Enable_HUD_Pokable_Indicator(MainTermObj,false);
	}
}

// ***** //

void KAK_Vehicle_Scroll::Poked(GameObject *obj, GameObject *poker) {
	if (Commands->Get_Player_Type(poker) == Commands->Get_Player_Type(obj)) {
		if (MainTermObj == 0) {
			MainTermObj = Commands->Create_Object("VehTerminal_Base_Empty",MainTerm);
			Commands->Set_Facing(MainTermObj,90.0f);
			Commands->Attach_Script(MainTermObj,"KAK_Vehicle_Purchase","");
		}
		else {
			int order = 0;
			if (strstr(Commands->Get_Preset_Name(MainTermObj),"HV")) order = 1;
			else if (strstr(Commands->Get_Preset_Name(MainTermObj),"APC")) order = 2;
			else if (strstr(Commands->Get_Preset_Name(MainTermObj),"MRLS")) order = 3;
			else if (strstr(Commands->Get_Preset_Name(MainTermObj),"Med")) order = 4;
			else if (strstr(Commands->Get_Preset_Name(MainTermObj),"Mam")) order = 5;
			else if (strstr(Commands->Get_Preset_Name(MainTermObj),"Empty")) order = 6;

			if (Get_Int_Parameter("Direction") == 0 && order != 0) { //down
				Commands->Destroy_Object(MainTermObj);
				if (order == 1) MainTermObj = Commands->Create_Object("VehTerminal_Base_Mam",MainTerm);
				else if (order == 2) MainTermObj = Commands->Create_Object("VehTerminal_Base_HV",MainTerm);
				else if (order == 3) MainTermObj = Commands->Create_Object("VehTerminal_Base_APC",MainTerm);
				else if (order == 4) MainTermObj = Commands->Create_Object("VehTerminal_Base_MRLS",MainTerm);
				else if (order == 5) MainTermObj = Commands->Create_Object("VehTerminal_Base_Med",MainTerm);
				else if (order == 6) MainTermObj = Commands->Create_Object("VehTerminal_Base_Mam",MainTerm);
				if (MainTermObj != 0) {
					Commands->Set_Facing(MainTermObj,90.0f);
					Commands->Attach_Script(MainTermObj,"KAK_Vehicle_Purchase","");
				}
			}
			else if (Get_Int_Parameter("Direction") == 1 && order != 0) { //up
				Commands->Destroy_Object(MainTermObj);
				if (order == 1) MainTermObj = Commands->Create_Object("VehTerminal_Base_APC",MainTerm);
				else if (order == 2) MainTermObj = Commands->Create_Object("VehTerminal_Base_MRLS",MainTerm);
				else if (order == 3) MainTermObj = Commands->Create_Object("VehTerminal_Base_Med",MainTerm);
				else if (order == 4) MainTermObj = Commands->Create_Object("VehTerminal_Base_Mam",MainTerm);
				else if (order == 5) MainTermObj = Commands->Create_Object("VehTerminal_Base_HV",MainTerm);
				else if (order == 6) MainTermObj = Commands->Create_Object("VehTerminal_Base_HV",MainTerm);
				if (MainTermObj != 0) {
					Commands->Set_Facing(MainTermObj,90.0f);
					Commands->Attach_Script(MainTermObj,"KAK_Vehicle_Purchase","");
				}
			}
		}
	}
}

// ***** //

void KAK_Vehicle_Purchase::Created(GameObject *obj) {
	Commands->Enable_HUD_Pokable_Indicator(MainTermObj,CanBuild);
}

void KAK_Vehicle_Purchase::Poked(GameObject *obj,GameObject *poker) {
	if (Commands->Get_Player_Type(poker) == Commands->Get_Player_Type(obj)) {
		if (CanBuild) {
			std::string Vehicle_Purchase;
			if (strstr(Commands->Get_Preset_Name(MainTermObj),"HV")) Vehicle_Purchase = "CnC_GDI_Humm-vee";
			else if (strstr(Commands->Get_Preset_Name(MainTermObj),"APC")) Vehicle_Purchase = "CnC_GDI_APC";
			else if (strstr(Commands->Get_Preset_Name(MainTermObj),"MRLS")) Vehicle_Purchase = "CnC_GDI_MRLS";
			else if (strstr(Commands->Get_Preset_Name(MainTermObj),"Med")) Vehicle_Purchase = "CnC_GDI_Medium_Tank";
			else if (strstr(Commands->Get_Preset_Name(MainTermObj),"Mam")) Vehicle_Purchase = "CnC_GDI_Mammoth_Tank";
			else Vehicle_Purchase = "null";

			if (strcmp(Vehicle_Purchase.c_str(),"null") != 0) {
				if (strcmp(Vehicle_Purchase.c_str(),"CnC_GDI_Humm-vee") == 0) {
					if ((Commands->Get_Money(poker) - 350) < 0) {
						Commands->Create_2D_WAV_Sound("m00evag_dsgn0028i1evag_snd.wav");
					}
					else {
						Commands->Give_Money(poker,-350,false);
						Create_Vehicle(Vehicle_Purchase.c_str(),0,poker,Commands->Get_Player_Type(poker));
						Commands->Send_Custom_Event(obj,ControlObj,1050,0,0);
						Commands->Create_2D_WAV_Sound("m00bgwf_dsgn0003i1evag_snd.wav");
					}
				}
				else if (strcmp(Vehicle_Purchase.c_str(),"CnC_GDI_APC") == 0) {
					if ((Commands->Get_Money(poker) - 500) < 0) {
						Commands->Create_2D_WAV_Sound("m00evag_dsgn0028i1evag_snd.wav");
					}
					else {
						Commands->Give_Money(poker,-500,false);
						Create_Vehicle(Vehicle_Purchase.c_str(),0,poker,Commands->Get_Player_Type(poker));
						Commands->Send_Custom_Event(obj,ControlObj,1050,0,0);
						Commands->Create_2D_WAV_Sound("m00bgwf_dsgn0003i1evag_snd.wav");
					}
				}
				else if (strcmp(Vehicle_Purchase.c_str(),"CnC_GDI_MRLS") == 0) {
					if ((Commands->Get_Money(poker) - 450) < 0) {
						Commands->Create_2D_WAV_Sound("m00evag_dsgn0028i1evag_snd.wav");
					}
					else {
						Commands->Give_Money(poker,-450,false);
						Create_Vehicle(Vehicle_Purchase.c_str(),0,poker,Commands->Get_Player_Type(poker));
						Commands->Send_Custom_Event(obj,ControlObj,1050,0,0);
						Commands->Create_2D_WAV_Sound("m00bgwf_dsgn0003i1evag_snd.wav");
					}
				}
				else if (strcmp(Vehicle_Purchase.c_str(),"CnC_GDI_Medium_Tank") == 0) {
					if ((Commands->Get_Money(poker) - 800) < 0) {
						Commands->Create_2D_WAV_Sound("m00evag_dsgn0028i1evag_snd.wav");
					}
					else {
						Commands->Give_Money(poker,-800,false);
						Create_Vehicle(Vehicle_Purchase.c_str(),0,poker,Commands->Get_Player_Type(poker));
						Commands->Send_Custom_Event(obj,ControlObj,1050,0,0);
						Commands->Create_2D_WAV_Sound("m00bgwf_dsgn0003i1evag_snd.wav");
					}
				}
				else if (strcmp(Vehicle_Purchase.c_str(),"CnC_GDI_Mammoth_Tank") == 0) {
					if ((Commands->Get_Money(poker) - 1500) < 0) {
						Commands->Create_2D_WAV_Sound("m00evag_dsgn0028i1evag_snd.wav");
					}
					else {
						Commands->Give_Money(poker,-1500,false);
						Create_Vehicle(Vehicle_Purchase.c_str(),0,poker,Commands->Get_Player_Type(poker));
						Commands->Send_Custom_Event(obj,ControlObj,1050,0,0);
						Commands->Create_2D_WAV_Sound("m00bgwf_dsgn0003i1evag_snd.wav");
					}
				}
			}
		}
		else {
			Commands->Create_2D_WAV_Sound("m00evag_dsgn0012i1evag_snd.wav");
		}
	}
}

// ***** //

void KAK_Enter_AGT::Created(GameObject *obj) {
	Commands->Enable_HUD_Pokable_Indicator(obj,true);
}

void KAK_Enter_AGT::Poked(GameObject *obj, GameObject *poker) {
	Vector3 NewPos;
	NewPos.X = 2.541f;
	NewPos.Y = 47.118f;
	NewPos.Z = 17.867f;
	Commands->Set_Position(poker,NewPos);
	//Commands->Clear_Weapons(Find_Object_By_Preset(1,"GDI_AGT"));
	Commands->Set_Building_Power(Find_Base_Defense(1),false);
	Commands->Attach_Script(poker,"KAK_Control_AGT","");
	AGTExitObj = Commands->Create_Object("AGT_Exit",AGTExit);
	Commands->Attach_Script(AGTExitObj,"KAK_Exit_AGT","");
	Commands->Destroy_Object(obj);
}

// ***** //

void KAK_Station_AGT::Created(GameObject *obj) {
	AGTEnter.X = 6.049f;
	AGTEnter.Y = 52.939f;
	AGTEnter.Z = -2.480f;
	AGTExit.X = 3.132f;
	AGTExit.Y = 47.118f;
	AGTExit.Z = 15.200f;
	AGTEnterObj = Commands->Create_Object("AGT_Enter",AGTEnter);
	Commands->Set_Facing(AGTEnterObj,-90.0f);
	Commands->Attach_Script(AGTEnterObj,"KAK_Enter_AGT","");
}

// ***** //

void KAK_Control_AGT::Created(GameObject *obj) {
	Commands->Clear_Weapons(obj);
	Commands->Give_Powerup(obj,"POW_AGTWeapon_Player",true);
	Commands->Select_Weapon(obj,"Weapon_AGT_Player");
	Position = Commands->Get_Position(obj);
	Toggle_Fly_Mode(obj);
	Commands->Set_Model(obj,"v_invs_turret");
	Commands->Start_Timer(obj,this,0.1f,1);
}

void KAK_Control_AGT::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		Commands->Set_Position(obj,Position);
		Commands->Start_Timer(obj,this,0.1f,1);
	}
}

void KAK_Control_AGT::Damaged(GameObject *obj, GameObject *damager, float damage) {
	Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
	Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
}

// ***** //

void KAK_Exit_AGT::Poked(GameObject *obj, GameObject *poker) {
	Commands->Destroy_Object(poker);
	Commands->Set_Building_Power(Find_Base_Defense(1),true);
	AGTEnterObj = Commands->Create_Object("AGT_Enter",AGTEnter);
	Commands->Attach_Script(AGTEnterObj,"KAK_Enter_AGT","");
	Commands->Set_Facing(AGTEnterObj,-90.0f);
	Commands->Destroy_Object(obj);
}

// ***** //

// ***** //

Vector3 Bot1, Bot2, TriggerStation;
GameObject *Bot1Obj, *Bot2Obj, *TS;

void KAK_Trigger_Fight::Created(GameObject *obj) {
	TS = obj;
	TriggerStation = Commands->Get_Position(obj);
	Bot1.X = -39.099f;
	Bot1.Y = 13.068f;
	Bot1.Z = -3.484f;
	Bot2.X = -39.099f;
	Bot2.Y = 14.198f;
	Bot2.Z = -3.484f;
}

void KAK_Trigger_Fight::Poked(GameObject *obj, GameObject *poker) {
	Bot1Obj = Commands->Create_Object("CnC_GDI_Minigunner_0",Bot1);
	Commands->Set_Facing(Bot1Obj,90.0f);
	Commands->Attach_Script(Bot1Obj,"KAK_FightBot_1","");
	Bot2Obj = Commands->Create_Object("CnC_Nod_Minigunner_0",Bot2);
	Commands->Set_Facing(Bot2Obj,-90.0f);
	Commands->Attach_Script(Bot2Obj,"KAK_FightBot_2","");
	Commands->Destroy_Object(obj);
}

// ***** //

void KAK_FightBot_1::Created(GameObject *obj) {
	Commands->Clear_Weapons(obj);
	Commands->Set_Animation(obj,"",false,0,0.0f,-1.0f,false);
}

void KAK_FightBot_1::Animation_Complete(GameObject *obj,const char *anim) {
	if (strstr(anim,"FLYKICK")) {
		Commands->Set_Animation(Bot2Obj,"h_a_635a",false,0,0.0f,-1.0f,false);
	}
	if (strstr(anim,"631A")) {
		Commands->Destroy_Object(obj);
		Commands->Set_Animation(Bot2Obj,"h_a_a0a0_L58",false,0,0.0f,-1.0f,false);
	}
}

// ***** //

void KAK_FightBot_2::Created(GameObject *obj) {
	Commands->Clear_Weapons(obj);
	Commands->Set_Animation(obj,"h_a_a0a0_L12",false,0,0.0f,-1.0f,false);
}

void KAK_FightBot_2::Animation_Complete(GameObject *obj,const char *anim) {
	if (strstr(anim,"A0A0_L12")) {
		Commands->Set_Animation(Bot1Obj,"h_a_flykick",false,0,0.0f,-1.0f,false);
	}
	if (strstr(anim,"635A")) {
		Commands->Set_Animation(Bot2Obj,"h_a_cresentkick",false,0,0.0f,-1.0f,false);
	}
	if (strstr(anim,"CRESENTKICK")) {
		Commands->Set_Animation(Bot1Obj,"h_a_631a",false,0,0.0f,-1.0f,false);
	}
	if (strstr(anim,"A0A0_L58")) {
		Commands->Destroy_Object(obj);
		TS = Commands->Create_Object("Fight_Trigger",TriggerStation);
		Commands->Attach_Script(TS,"KAK_Trigger_Fight","");
	}
}

ScriptRegistrant<KAK_Vehicle_Purchase> KAK_Vehicle_Purchase_Registrant("KAK_Vehicle_Purchase","");
ScriptRegistrant<KAK_Vehicle_Init> KAK_Vehicle_Init_Registrant("KAK_Vehicle_Init","");
ScriptRegistrant<KAK_Vehicle_Scroll> KAK_Vehicle_Scroll_Registrant("KAK_Vehicle_Scroll","Direction:int");
ScriptRegistrant<KAK_Control_AGT> KAK_Control_AGT_Registrant("KAK_Control_AGT","");
ScriptRegistrant<KAK_Enter_AGT> KAK_Enter_AGT_Registrant("KAK_Enter_AGT","");
ScriptRegistrant<KAK_Exit_AGT> KAK_Exit_AGT_Registrant("KAK_Exit_AGT","");
ScriptRegistrant<KAK_Station_AGT> KAK_Station_AGT_Registrant("KAK_Station_AGT","");
ScriptRegistrant<KAK_Trigger_Fight> KAK_Trigger_Fight_Registrant("KAK_Trigger_Fight","");
ScriptRegistrant<KAK_FightBot_1> KAK_FightBot_1_Registrant("KAK_FightBot_1","");
ScriptRegistrant<KAK_FightBot_2> KAK_FightBot_2_Registrant("KAK_FightBot_2","");
